#ifndef KRAMPUS_INC_KRAMPUS_HPP
#define KRAMPUS_INC_KRAMPUS_HPP

#include <cmath>
#include <string>
#include <vector>
#include <sstream>
#include <iostream>

#include <allegro5/allegro.h>
#include <allegro5/allegro_font.h>
#include <allegro5/allegro_audio.h>
#include <allegro5/allegro_primitives.h>

using std::pow;
using std::cout;
using std::sqrt;
using std::string;
using std::vector;
using std::stringstream;

class Krampus {

  public:

    Krampus(void);

    void loop(void);

    void initialize(const unsigned int);

    void loadResources(void);

    void destroyResources(void);

    string getName(void);

  private:

    string kitten_names[10];

    int x1;
    int x2;
    int y1;
    int y2;

    float alpha[3];

    unsigned int state;

    unsigned int hours;
    unsigned int minutes;
    unsigned int seconds;

    unsigned int kittens_found;

    int distances[10];

    int shortest_distance;
    int shortest_distance_kitten_number;

    enum Keys {UP = 0, DOWN, LEFT, RIGHT};

    bool show_extras;

    unsigned int cool_down;

    bool keys[4];

    bool fade_intro;

    bool ready_to_win;
    bool ready_to_lose;

    float gain;

    stringstream current_time;

    ALLEGRO_FONT *built_in_font;

    ALLEGRO_SAMPLE *kitten_meow_sample;

    ALLEGRO_BITMAP *kitten_bitmap;

    ALLEGRO_BITMAP *map_bitmap;

    ALLEGRO_SAMPLE *background_sample;
    ALLEGRO_SAMPLE_INSTANCE *background_sample_instance;
};

#endif
